% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/network_visual.R
\name{network_visual}
\alias{network_visual}
\title{Network Visualization}
\usage{
network_visual(
  network_obj,
  mode = "major_module",
  major_num = 5,
  taxlevel = NULL,
  select_tax = NULL,
  palette = "Set1",
  vertex.size = 6
)
}
\arguments{
\item{network_obj}{A network analysis results object generated from \code{\link{network_analysis}}.}

\item{mode}{The visualization mode, optionally "major_module" or "major_tax".}

\item{major_num}{The number of major modules to display in the network.}

\item{taxlevel}{Taxonomy levels used for visualization when mode is "major_tax".}

\item{select_tax}{A vector of taxa to be selected for displaying in "major_tax" mode.}

\item{palette}{Character. Palette for visualization.}

\item{vertex.size}{Numeric. The size of the vertices.}
}
\value{
A list containing the configured igraph object and the coordinates of the vertices, with network visualization displayed in the plots panel.
}
\description{
Visualizes a network based on a network object from \code{\link{network_analysis}}.
}
\examples{
\donttest{
{
  # Data preparation
  data("Two_group")
  set.seed(999)
  # Analysis
  network_results <- network_analysis(
    taxobj = Two_group,
    taxlevel = "Species",
    n = 10,
    threshold = 0.6
  )

  # Default mode
  network_visual_obj <- network_visual(network_obj = network_results)

  # View again
  network_visual_re(network_visual_obj)

  # More modules
  network_visual_obj <- network_visual(
    network_obj = network_results,
    major_num = 10
  )

  # Specific tax
  # Generate top 5 phyla for displaying
  community <- community_plot(
    taxobj = Two_group,
    taxlevel = "Phylum",
    n = 5,
    palette = "Paired"
  )
  display_phyla <- names(community$filled_color)

  network_visual_obj <- network_visual(
    network_obj = network_results,
    mode = "major_tax",
    taxlevel = "Phylum",
    select_tax = display_phyla,
    palette = community$filled_color
  )

  # Another sample for specific tax
  network_visual_obj <- network_visual(
    network_obj = network_results,
    mode = "major_tax",
    taxlevel = "Phylum",
    select_tax = "p__Proteobacteria"
  )
}
}
}
