% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cost.R
\name{cost}
\alias{cost}
\title{Calculate the cost}
\usage{
cost(new_WL_list, init_list, lambda)
}
\arguments{
\item{new_WL_list}{A list of matrices factorized from the similarity matrices list WL}

\item{init_list}{A list containing the updated result in this iteration}

\item{lambda}{A parameter to set the relative weight of the group sparsity constraints}
}
\value{
A number indicating the total cost of the objective function
}
\description{
A function to calculate the cost of the objective function
}
\examples{

WL <- simu_data_gen()
WL[[1]] <- affinityMatrix(dist2eu(Standard_Normalization(WL[[1]]),Standard_Normalization(WL[[1]])))
WL[[2]] <- affinityMatrix(dist2eu(Standard_Normalization(WL[[2]]),Standard_Normalization(WL[[2]])))
new_WL_list <- initialize_WL(WL)
k <- 5
lambda <- 0.25
init_list <- initialization(new_WL_list,k)
update_L_list <- update_L(new_WL_list,init_list)
update_alpha_list <- update_alpha(new_WL_list,update_L_list,lambda)
init_list <- update_alpha_list
new_loss <- cost(new_WL_list,init_list,lambda)
}
\author{
Xiaoyao Yin
}
