% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_matching2wider.R
\name{check_matching2wider}
\alias{check_matching2wider}
\title{Convert a Longer Table Generated by check_matching() Into a Wider Table}
\arguments{
\item{baseline.longer}{A data frame containing the summarised results
generated by \emph{check_matching()}.}

\item{intervention.arm}{The name of the grouping column in the data frame
specified by \emph{ipds}, e.g., intervention.arm = TRT. The default is TRT.}

\item{digits}{Specify the number of decimal places for the output results.}
}
\value{
A data frame containing the summarized results in a wider format.
}
\description{
Convert a Longer Table Generated by check_matching() Into a Wider Table
}
\examples{
\donttest{
cov <- list(
  binary = c("ECOG", "SMK", "METBRAIN"),
  continuous = c("BMI", "DIAG")
)

cov_all <- list(
  binary = c("SEX", "ECOG", "SMK", "METBRAIN", "METLIVER"),
  continuous = c("BMI", "DIAG", "WEIGHT", "HEIGHT")
)

baseline <- check_matching(
  ipds_wts = pts, agds = AgD_bl,
  summary.list = cov_all, matching.list = cov,
  intervention.arm = TRT,
  comparator = STUDY, comparator.study = "Study XX-1",
  comparator.n = N, comparator.arm = TRT)

baseline_summary <- check_matching2wider(
  baseline.longer = baseline,
  intervention.arm = TRT)

baseline_summary
}

}
