% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ASB.R
\name{ASB}
\alias{ASB}
\title{Absolute standardized bias}
\usage{
ASB(data, confounders, treatment, verbose = TRUE)
}
\arguments{
\item{data}{A dataframe or equivalent.}

\item{confounders}{A vector with the column names of the confounders to balance by.}

\item{treatment}{A string with the column name of the treatment variable.}

\item{verbose}{Set to FALSE to suppress any console output. Default is TRUE}
}
\value{
A list of objects, containing the ASB matrix and some summary statistics.
}
\description{
Compute the absolute standardized bias of given confounders and return some
useful statistics.
}
\examples{
ASB(data = MARMoT_data, confounders = c("race", "age"), treatment = "hospital")

}
