% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/avoid.R
\name{as_complex}
\alias{as_complex}
\alias{as_complex,xy,missing-method}
\alias{as_complex,numeric,numeric-method}
\alias{as_complex,numeric,missing-method}
\alias{as_complex,missing,numeric-method}
\title{Coerce to complex}
\usage{
as_complex(x, y)

\S4method{as_complex}{xy,missing}(x)

\S4method{as_complex}{numeric,numeric}(x, y)

\S4method{as_complex}{numeric,missing}(x, y)

\S4method{as_complex}{missing,numeric}(x, y)
}
\arguments{
\item{x}{A numeric vector or missing, or an object inheriting from class "xy"}

\item{y}{If x is a numeric an optional numeric vector, or missing. If x or y are
missing they are taken as 0, but only one may be missing.}
}
\value{
A complex vector specifying 2-dimensional coordinates
}
\description{
Utility function to create complex vectors from arguments
specified as in grDevices::xy.coords() or otherwise
}
\examples{
as_complex(cbind(1:3, 3:1))
as_complex(y = 1:3)  ## real parts all zero
}
