% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepare.functions.R
\name{DR.comparisons}
\alias{DR.comparisons}
\title{Adds placebo comparisons for dose-response relationship}
\usage{
DR.comparisons(data.ab, level = "treatment", doselink = NULL)
}
\arguments{
\item{data.ab}{A data frame stored in an \code{mbnma.network} object (\code{mbnma.network$data.ab})}

\item{level}{A character that can take either \code{"treatment"} or \code{"agent"} to indicate the level of the
network for which to identify dose-response}

\item{doselink}{If given an integer value it indicates that connections via the dose-response
relationship with placebo should be plotted. The integer represents the minimum number of doses
from which a dose-response function could be estimated and is equivalent to the number of
parameters in the desired dose-response function plus one. If left as \code{NULL} (the default), connections
to placebo via dose-response relationships will not be included.}
}
\description{
Function adds additional rows to a data.frame of comparisons in a network that account
for the relationship between placebo and other agents via the dose-response
relationship.
}
