% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dose.functions.R
\name{ditp}
\alias{ditp}
\title{Integrated Two-Component Prediction (ITP) function}
\usage{
ditp(emax = "rel", rate = "rel", p.expon = FALSE)
}
\arguments{
\item{emax}{Pooling for Emax  parameter. Can take \code{"rel"}, \code{"common"}, \code{"random"} or be
assigned a numeric value (see details).}

\item{rate}{Pooling for Rate parameter. Can take \code{"rel"}, \code{"common"}, \code{"random"} or be
assigned a numeric value (see details).}

\item{p.expon}{A logical object to indicate whether \code{ed50} and \code{hill} parameters should be
expressed within the dose-response function on an exponential scale}
}
\value{
An object of \code{class("dosefun")}
}
\description{
Similar parameterisation to the Emax model but with non-asymptotic maximal effect (Emax). Proposed
by proposed by \insertCite{fumanner;textual}{MBNMAdose}
}
\details{
Emax represents the maximum response.
Rate represents the rate at which a change in the dose of the drug leads to
a change in the effect

\deqn{{E_{max}}\times\frac{(1-exp(-{rate}\times{x}))}{(1-exp(-{rate}\times{max(x)}))}}
}
\section{Dose-response parameters}{
\tabular{ll}{
   \strong{Argument} \tab \strong{Model specification} \cr
   \code{"rel"} \tab Implies that \emph{relative} effects should be pooled for this dose-response parameter separately for each agent in the network. \cr
   \code{"common"} \tab Implies that all agents share the same common effect for this dose-response parameter. \cr
   \code{"random"} \tab Implies that all agents share a similar (exchangeable) effect for this dose-response parameter. This approach allows for modelling of variability between agents. \cr
   \code{numeric()} \tab Assigned a numeric value, indicating that this dose-response parameter should not be estimated from the data but should be assigned the numeric value determined by the user. This can be useful for fixing specific dose-response parameters (e.g. Hill parameters in Emax functions) to a single value. \cr
}


When relative effects are modelled on more than one dose-response parameter,
correlation between them is automatically estimated using a vague inverse-Wishart prior.
This prior can be made slightly more informative by specifying the scale matrix \code{omega}
and by changing the degrees of freedom of the inverse-Wishart prior
using the \code{priors} argument in \code{mbnma.run()}.
}

\examples{
# Model a common effect on rate
ditp(emax="rel", rate="common")

}
\references{
\insertAllCited
}
