% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MRMfit.R
\name{MRMfit}
\alias{MRMfit}
\title{Fit Mixed Regression Model with Log-Gamma Random Effects}
\usage{
MRMfit(formula, data, hessian = TRUE, method = "BFGS", ...)
}
\arguments{
\item{formula}{A symbolic description of the model to be fitted, e.g., \code{y ~ x1 + x2}.
The response variable must be binary (0/1).}

\item{data}{A data frame containing the variables in the model. The data must include an
\code{Ind} column indicating cluster or subject IDs for the random effects.}

\item{hessian}{Logical. Should a numerically differentiated Hessian matrix be returned?}

\item{method}{Optimization method to be used in \code{\link[stats]{optim}}. One of
\code{"Nelder-Mead"}, \code{"BFGS"}, \code{"CG"}, \code{"L-BFGS-B"}, \code{"SANN"}, or \code{"Brent"}.
Default is \code{"BFGS"}.}

\item{...}{Additional arguments passed to \code{\link[stats]{optim}}, such as \code{control},
\code{lower}, or \code{upper} (when supported by the chosen method).}
}
\value{
An object of class \code{"MRM"} containing:
\item{call}{The matched function call.}
\item{formula}{The model formula.}
\item{coefficients}{Estimated fixed effects coefficients.}
\item{scale}{Estimated scale parameter for the random effects distribution.}
\item{loglik}{Maximized log-likelihood value.}
\item{n}{Number of clusters or subjects.}
\item{m}{Vector with the number of observations per cluster.}
\item{ep}{Estimated standard errors of the parameters.}
\item{iter}{Number of iterations used by the optimizer.}
\item{method}{Optimization method used.}
\item{data}{The original data frame used.}
}
\description{
This function fits a mixed regression model for binary outcomes with random effects
following a generalized log-gamma distribution. The estimation is performed by maximizing
a custom log-likelihood using numerical optimization via \code{\link[stats]{optim}}.
}
\examples{
# Simulated data
data1 <- rMRM(n = 50, m = rep(3, 50),
              theta = c(0.8, 1, -1, 1),
              X = cbind(x1 = rnorm(150), x2 = rnorm(150)))

# Fit using BFGS (default)
fit1 <- MRMfit(y ~ x1 + x2, data = data1)
summary(fit1)

# Fit using L-BFGS-B with bounds
fit2 <- MRMfit(y ~ x1 + x2, data = data1,
               method = "L-BFGS-B",
               lower = c(1e-5, rep(-Inf, 3)),
               upper = rep(Inf, 4),
               control = list(factr = 1e7))
summary(fit2)

}
