% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.weibreg.R
\name{summary.weibreg}
\alias{summary.weibreg}
\alias{print.weibreg}
\title{Print a summary for a object of the \code{weibreg} class.}
\usage{
\method{summary}{weibreg}(object, ...)

\method{print}{weibreg}(x, digits = max(3L, getOption("digits") - 3L), ...)
}
\arguments{
\item{object}{an object of the \code{weibreg} class.}

\item{...}{additional arguments affecting the summary produced.}

\item{x}{an object of class \code{summary.weibreg}, usually, a result of a call to 
	\code{summary.weibreg}.}

\item{digits}{the number of significant digits to use when printing.}
}
\value{
A complete summary for the coefficients extracted from a \code{weibreg} object.
}
\description{
Summarizes the results for a object of the \code{weibreg} class.
}
\section{Functions}{
\itemize{
\item \code{print(weibreg)}: 

}}
\references{
Diniz, Márcio A. and Gallardo, Diego I. and Magalhães, Tiago M. (2023). Improved inference 
for MCP-Mod approach for time-to-event endpoints with small sample sizes. arXiv 
<doi.org/10.48550/arXiv.2301.00325>
}
\examples{
require(survival)
set.seed(2100)

##Generating covariates
n=20 
x<-runif(n, max=10)
lambda<-exp(1.2-0.5*x)
sigma<-1.5

##Drawing T from Weibull model and fixing censoring at 1.5
T<-rweibull(n, shape=1/sigma, scale=lambda)
L<-rep(1.5, n)

##Defining the observed times and indicators of failure
t<-pmin(T,L)
delta<-ifelse(T<=L, 1, 0)
data=data.frame(t=t, delta=delta, x=x)

##Fitting for Weibull regression model

##Traditional MLE with corrected variance
ex1=weibfit(Surv(t,delta)~x, data=data, L=L, estimator="MLE", 
	corrected.var=TRUE)
summary(ex1)

##BCE without corrected variance
ex2=weibfit(Surv(t,delta)~x, data=data, L=L, estimator="Firth", 
	corrected.var=FALSE)
summary(ex2)

##BCE with corrected variance
ex3=weibfit(Surv(t,delta)~x, data=data, L=L, estimator="BCE", 
	corrected.var=TRUE)
summary(ex3)

##Firth's correction without corrected variance
ex4=weibfit(Surv(t,delta)~x, data=data, L=L, estimator="BCE", 
	corrected.var=FALSE)
summary(ex4)

}
