% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions.R
\name{dbs}
\alias{dbs}
\title{Compute the Density-based Silhouette}
\usage{
dbs(z,
    ztol = 1E-100,
    weights = NULL,
    summ = c("mean", "median"),
    clusters = NULL,
    ...)
}
\arguments{
\item{z}{A numeric matrix such that rows correspond to observations, columns correspond to clusters, and rows sum to \code{1}.}

\item{ztol}{A small (single, numeric, non-negative) tolerance parameter governing whether small assignment probabilities are treated instead as crisp assignments. Defaults to \code{1E-100}.}

\item{weights}{An optional numeric vector giving observation-specific weights for computing the (weighted) mean/median DBS (see \code{summ}).}

\item{summ}{A single character string indicating whether the (possibly weighted) \code{"mean"} (the default) or \code{"median"} DBS should be computed.}

\item{clusters}{Optional/experimental argument for giving the indicator labels of the cluster assignments. Defaults to the MAP assignment derived from \code{z} when not supplied. Note that actually supplying the MAP assignment here is slightly less efficient than the \code{NULL} default and \strong{not} advised.}

\item{...}{Catches unused arguments.}
}
\value{
A list with the following elements:
\describe{
\item{\code{silvals}}{A matrix where each row contains the cluster to which each observation belongs in the first column and the observation-specific DBS width in the second column.}
\item{\code{msw}}{Depending on the value of \code{summ}, either the mean or median DBS width.}
\item{\code{wmsw}}{Depending on the value of \code{summ}, either the weighted mean or weighted median DBS width.}}
}
\description{
Computes the Density-based Silhouette for a `soft' clustering assignment matrix.
}
\note{
When calling \code{\link{MEDseq_fit}}, the \code{summ} argument can be passed via the \code{...} construct, in which case it governs both the \code{dbs} and \code{asw} criteria.
}
\examples{
# Generate a toy z matrix
z <- abs(matrix(rnorm(50), ncol=2))
z <- z/rowSums(z)

# Return the median DBS width
dbs(z, summ="median")$msw

# For real sequence data
data(mvad)
\donttest{
mod <- MEDseq_fit(seqdef(mvad[,17:86]), G=11, modtype="UUN", weights=mvad$weight)

dbs(mod$z, weights=mvad$weight)}
}
\references{
Menardi, G. (2011). Density-based silhouette diagnostics for clustering methods. \emph{Statistics and Computing}, 21(3): 295-308.
}
\seealso{
\code{\link{MEDseq_fit}}
}
\author{
Keefe Murphy - <\email{keefe.murphy@mu.ie}>
}
\keyword{utility}
