% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/power.binom.test.R
\name{power_binom_test}
\alias{power_binom_test}
\title{Power Calculations for Exact Test of a simple null hypothesis in a Bernoulli
experiment}
\usage{
power_binom_test(
  n = NULL,
  p0 = NULL,
  pa = NULL,
  sig.level = 0.05,
  power = NULL,
  alternative = c("two.sided", "less", "greater")
)
}
\arguments{
\item{n}{Number of observations}

\item{p0}{Probability under the null}

\item{pa}{Probability under the alternative}

\item{sig.level}{Significance level (Type I error probability)}

\item{power}{Power of test (1 minus Type II error probability)}

\item{alternative}{One- or two-sided test}
}
\value{
Object of class \code{power.htest}, a list of the arguments
(including the computed one) augmented with method and note elements.
}
\description{
Compute power of test, or determine parameters to obtain target power.
}
\details{
The procedure uses uniroot to find the root of a discontinuous function so
some errors may pop up due to the given setup that causes the root-finding
procedure to fail. Also, since exact binomial tests are used we have
discontinuities in the function that we use to find the root of but despite
this the function is usually quite stable.
}
\examples{

power_binom_test(n = 50, p0 = .50, pa = .75)      ## => power = 0.971
power_binom_test(p0 = .50, pa = .75, power = .90) ## =>     n = 41
power_binom_test(n = 50, p0 = .25, power = .90, alternative="less")  ## => pa = 0.0954

}
\seealso{
\code{\link{binom.test}}
}
\author{
Claus Ekstrom \email{claus@rprimer.dk}
}
\keyword{htest}
