% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MVSIS.R
\name{MVSIS}
\alias{MVSIS}
\title{Model-Free Feature Screening for Ultrahigh Dimensional Discriminant Analysis}
\usage{
MVSIS(X, Y, nsis)
}
\arguments{
\item{X}{The design matrix of dimensions n * p. Each row is an observation vector.}

\item{Y}{The response vector of dimension n * 1.}

\item{nsis}{Number of predictors recruited by MVSIS. The default is n/log(n).}
}
\value{
the labels of first nsis largest active set of all predictors
}
\description{
A marginal feature screening procedure based on empirical conditional distribution function.
The response variable is categorical in discriminant analysis.
This method uses the conditional distribution function to construct a new index for feature screening.
}
\examples{

n <- 100
p <- 200
rho <- 0.5
data <- GendataLGM(n, p, rho)
data <- cbind(data[[1]], data[[2]])
colnames(data)[1:ncol(data)] <- c(paste0("X", 1:(ncol(data) - 1)), "Y")
data <- as.matrix(data)
X <- data[, 1:(ncol(data) - 1)]
Y <- data[, ncol(data)]
A <- MVSIS(X, Y, n / log(n))
A

}
\references{
Cui, H., Li, R., & Zhong, W. (2015). Model-free feature screening for ultrahigh dimensional discriminant analysis. Journal of the American Statistical Association, 110(510), 630-641.
}
\author{
Xuewei Cheng \email{xwcheng@hunnu.edu.cn}
}
