% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interventions.R
\name{add_interventions}
\alias{add_interventions}
\title{This set of functions modifies mosquito life history parameters in the presence of
adult interventions - indoor residual spraying (IRS) and insecticide treated nets (ITN)
This is based on the work of Le Menach et al (2007) and Griffin et al (2010).
We vary three parameters in the presence of interventions:
Egg laying rate (beta)
Adult mortality (muF)
Mosquito biting rate (av0)}
\usage{
add_interventions(params, IRS_cov, LLIN_cov)
}
\arguments{
\item{params}{a named list of parameters}

\item{IRS_cov}{proportion of humans in the node receiving IRS}

\item{LLIN_cov}{proportion of humans in the node receiving LLIN}
}
\value{
a vector of the equilibrium number of females in each SEI stage
}
\description{
This set of functions modifies mosquito life history parameters in the presence of
adult interventions - indoor residual spraying (IRS) and insecticide treated nets (ITN)
This is based on the work of Le Menach et al (2007) and Griffin et al (2010).
We vary three parameters in the presence of interventions:
Egg laying rate (beta)
Adult mortality (muF)
Mosquito biting rate (av0)
}
