% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Cube-ShredderMF.R
\name{cubeXShredderMF}
\alias{cubeXShredderMF}
\title{Inheritance Cube: Autosomal X-Shredder}
\usage{
cubeXShredderMF(
  cM = 1,
  cF = 1,
  crM = 0,
  crF = 0,
  cbM = 0,
  cbF = 0,
  eta = NULL,
  phi = NULL,
  omega = NULL,
  xiF = NULL,
  xiM = NULL,
  s = NULL
)
}
\arguments{
\item{cM}{Rate of X shredding in males (default is 1, complete shredding)}

\item{cF}{Rate of X shredding in females (default is 1, complete shredding)}

\item{crM}{Rate of resistance chromosome generation in males (default is 0)}

\item{crF}{Rate of resistance chromosome generation in females (default is 0)}

\item{cbM}{Rate of shredder construct breakdown in males (default is 0)}

\item{cbF}{Rate of shredder construct breakdown in females (default is 0)}

\item{eta}{Genotype-specific mating fitness}

\item{phi}{Genotype-specific sex ratio at emergence}

\item{omega}{Genotype-specific multiplicative modifier of adult mortality}

\item{xiF}{Genotype-specific female pupatory success}

\item{xiM}{Genotype-specific male pupatory success}

\item{s}{Genotype-specific fractional reduction(increase) in fertility}
}
\value{
Named list containing the inheritance cube, transition matrix, genotypes, wild-type allele,
and all genotype-specific parameters.
}
\description{
This function creates an inheritance cube to model an autosomal X-Shredder construct.
This construct resides on an autosomal chromosome, and chops the X chromosome into
many pieces during gametogenesis, destroying the X chromosome. Thus, males
may only produce Y gametes and females can become sterile. \cr
This drive has 2 loci:
\itemize{
\item Locus 1, the autosomal locus, has 3 alleles:
\itemize{
\item W: Wild-type allele
\item A: Attacking allele, contains the shredder construct
\item B: Broken attacking allele, shredder construct is defunct
}
\item Locus 2, the sex locus, has 3 alleles:
\itemize{
\item X: Wild-type X allele
\item R: X-allele resistant to cleavage
\item Y: Wild-type Y allele
}
}
}
