% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Cube-CRISPR1RA.R
\name{cubeHoming1RA}
\alias{cubeHoming1RA}
\title{Inheritance Cube: Homing Drive with 1 Resistance Allele}
\usage{
cubeHoming1RA(
  c = 1,
  ch = 0,
  eta = NULL,
  phi = NULL,
  omega = NULL,
  xiF = NULL,
  xiM = NULL,
  s = NULL
)
}
\arguments{
\item{c}{Cutting rate}

\item{ch}{Successful homing rate rate}

\item{eta}{Genotype-specific mating fitness}

\item{phi}{Genotype-specific sex ratio at emergence}

\item{omega}{Genotype-specific multiplicative modifier of adult mortality}

\item{xiF}{Genotype-specific female pupatory success}

\item{xiM}{Genotype-specific male pupatory success}

\item{s}{Genotype-specific fractional reduction(increase) in fertility}
}
\value{
Named list containing the inheritance cube, transition matrix, genotypes, wild-type allele,
and all genotype-specific parameters.
}
\description{
This function creates an inheritance cube to model a homing gene drive (such as a CRISPR-Cas9 system)
that creates 1 type of resistance allele. It assumes no sex-specific inheritance patterns and the
construct is on an autosome.
}
