% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/table_utils.R
\name{table_pairwise_interaction}
\alias{table_pairwise_interaction}
\title{Friedman's H-Statistic Pairwise Interaction Table}
\usage{
table_pairwise_interaction(
  analysis_object,
  show_table = FALSE,
  normalize = TRUE
)
}
\arguments{
\item{analysis_object}{A fitted \code{wrap_object} with results from
\code{sensitivity_analysis(methods = "Friedman H-stat")} with pairwise
interactions computed internally.}

\item{show_table}{Logical. If TRUE, prints the resulting interaction table
to the console (default = FALSE).}

\item{normalize}{Logical. If TRUE (default), returns \strong{normalized} pairwise
interaction strengths; if FALSE, returns \strong{raw} interaction values.}
}
\value{
A tibble containing pairwise interaction strengths between all feature pairs,
in either normalized or raw form depending on the \code{normalize} argument.
}
\description{
The \strong{table_pairwise_interaction()} function computes \strong{pairwise
interaction strengths} between predictors using \strong{Friedman's H-statistic},
following the formulation described in \emph{Interpretable Machine Learning} by
Christoph Molnar. While the global H-statistic summarizes the overall
interaction strength of each individual feature, this function focuses
specifically on \strong{pairwise feature interactions}, quantifying how strongly
two variables interact in influencing the model's predictions. If
\code{normalize = TRUE}, interaction scores are returned on a \strong{0–1 scale} for
ease of comparison; if \code{FALSE}, raw interaction magnitudes are returned.
}
\examples{
# After running:
# wrap_object <- sensitivity_analysis(wrap_object, methods = "Friedman H-stat")
#
# Obtain normalized pairwise interactions:
# table_norm <- table_pairwise_interaction(wrap_object)
#
# Obtain raw interaction strengths:
# table_raw <- table_pairwise_interaction(wrap_object, normalize = FALSE)

}
\references{
Molnar, C. (2022). \emph{Interpretable Machine Learning}.\cr
\url{https://christophm.github.io/interpretable-ml-book/}
}
\seealso{
\code{\link{sensitivity_analysis}},
\code{\link{table_h2_total}}
}
