% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flagMean.R
\name{flagMean}
\alias{flagMean}
\title{Calculate the Flag mean of multiple subspaces}
\usage{
flagMean(LapList, k, laplacian = c("shift", "Ng", "sym", "rw"), plots = TRUE)
}
\arguments{
\item{LapList}{A list of Laplacian matrices}

\item{k}{A vector indicating how many eigenvectors to take from each Laplacian, i.e., the number of clusters in each view}

\item{laplacian}{One of \code{"shift"}, \code{"Ng"}, \code{"rw"} or \code{"sym"}. Should be the same type used to calculate your Laplacians}

\item{plots}{Whether or not to plot the singular values from SVD}
}
\value{
The output from a singular value decomposition. See \link[base]{svd}
}
\description{
Calculate the flag-mean of multiple subspaces. This method allows you to find the extrinsic mean of a finite set of subspaces. You can think of this as a median subspace. This method is also able to handle subspaces with different dimensions. See the references for more details
}
\details{
Despite the complex linear algebra to achieve this result, the opperation is very simple. This function concatonates (cbind) the given subspaces and then performs singular value decomposition on the resulting matrix. This gives the 'median' subspace of the given set of subspaces. We would then cluster on the columns of the \code{U} matrix just as we do in standard spectral clustering
}
\examples{

## Generating data with 2 and 3 distinct clusters
## Note that 'clustStruct' returns a list
n=120; k <- c(2,3)
dd <- clustStruct(n=n, p=30, k=k, noiseDat='random')

## Laplacians
L_list <- lapply(dd, kernelLaplacian, kernel="Spectrum", plots=FALSE, verbose=FALSE)

## Calculating the flag mean
fm <- flagMean(L_list, k=k, laplacian='shift')

## Knowing the true structure makes it much easier to know how
## many right singular vectors to grab. There are 4 distinct
## groups in these data from 'clustStruct'

trueGroups(n=n, k=k)

kmeans(fm$u[, 1:4], centers=4)
}
\references{
https://www.semanticscholar.org/paper/Flag-Manifolds-for-the-Characterization-of-in-Large-Marrinan-Beveridge/7d306512b545df98243f87cb8173df83b4672b18
https://www.sciencedirect.com/science/article/pii/S0024379514001669?via\%3Dihub
}
