% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MNormTest.R
\name{meancov.Test}
\alias{meancov.Test}
\title{Mean and Covariance Matrix Hypothesis Testing (Simultaneously)}
\usage{
meancov.Test(X, label, alpha = 0.05, verbose = TRUE)
}
\arguments{
\item{X}{The data matrix which is a matrix or data frame.}

\item{label}{A vector of group labels.}

\item{alpha}{The significance level. Default is 0.05.}

\item{verbose}{A boolean value. Default is TRUE. If TRUE, the null hypothesis will be displayed. If FALSE, the test will be carried out silently.}
}
\value{
An object of class "testResult", which is a list with the following elements:
\item{Conclusion}{The conclusion of the test.}
\item{Stat}{A data frame containing the statistics, p value and critical value.}
\item{SampMeanT}{The sample mean.}
\item{SampMeanWithin}{The sample mean of each group.}
\item{SdTotal}{The total sample deviation.}
\item{SdWithin}{The sample deviation of each group.}
\item{SdWithinT}{The sample deviation within group.}
\item{Df}{The degree of freedom.}
\item{sampleSize}{The sample size of each group.}
\item{d}{The Modified factor of the statistic.}
}
\description{
Test whether the mean vectors and covariance matrices of multiple multivariate normal populations are all equal simultaneously. Suppose we have k populations, the null hypothesis is "H0: mu1 = mu2 = ... = muk and Sigma1 = Sigma2 = ... = Sigmak".
}
\examples{
data(iris)
chart <- iris[, 1:4]
species <- iris[, 5]
# carry out the test
test1 <- meancov.Test(chart, species)
test2 <- meancov.Test(chart, species, verbose = FALSE)
# get the elements
test1$Stat
test1$SampMeanT
}
\references{
Huixuan, Gao. Applied Multivariate Statistical Analysis. Peking University Press, 2005: pp.90-91.
}
\author{
Xifeng Zhang
}
