% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/beta.est.R
\name{beta_est}
\alias{beta_est}
\title{Method of Moments Estimation of Beta distribution}
\usage{
beta_est(
  data,
  unknown = c("shape1", "shape2", "both"),
  shape1 = NULL,
  shape2 = NULL,
  plot = TRUE,
  curvecol = "red",
  ...
)
}
\arguments{
\item{data}{A numeric vector.}

\item{unknown}{A character string specifying which parameter is (are) unknown to the user.}

\item{shape1, shape2}{Non-negative parameters of the Beta distribution.}

\item{plot}{logical which controls whether the histogram of the data along with the density curve of the theoretical beta distribution with the estimated parameters.}

\item{curvecol}{color of the theoretical density curve}

\item{...}{additional plotting parameters}
}
\value{
the estimated parameters by the method of moments of the data assuming the underlying distribution is beta distribution
}
\description{
function to get the method of moment estimate(s) of beta distribution
}
\examples{
beta_est(rbeta(1000,shape1=2,shape2=1),unknown="shape2",shape1=2)#shape1 is known
beta_est(rbeta(1000,shape1=2,shape2=1),unknown="shape1",shape2=1)#shape2 is known
beta_est(rbeta(1000,shape1=2,shape2=1),unknown="both")#both will be estimated
}
