% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/srmc.R
\name{srmc}
\alias{srmc}
\title{Single-Reader Multi-Case ROC Analysis}
\usage{
srmc(response, test, case, data, cov = jackknife)
}
\arguments{
\item{response}{response metric expressed in terms of a package-supplied
performance \code{\link[=metrics]{metric}}.}

\item{test}{variable of test identifiers.}

\item{case}{variable of case identifiers.}

\item{data}{data frame containing the \code{response}, \code{test}, and
\code{case} variables.}

\item{cov}{function, function call, or character string naming the
\code{\link[=cov_methods]{method}} to use in calculating performance
metric covariances.}
}
\value{
Returns an \code{\link{mrmc}} class object.
}
\description{
Estimation and comparison of ROC performance metrics for single-reader
multi-case studies.
}
\examples{
VanDyke1 <- subset(VanDyke, reader == "1")
est <- srmc(empirical_auc(truth, rating), treatment, case, data = VanDyke1)
plot(est)
summary(est)

}
\seealso{
\code{\link{metrics}}, \code{\link{cov_methods}},
\code{\link{parameters}}, \code{\link{plot}}, \code{\link{roc_curves}},
\code{\link{summary}}
}
