% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mrstdlcrt.R
\name{plot.mrs}
\alias{plot.mrs}
\title{Plot estimates from an mrs fit}
\usage{
\method{plot}{mrs}(x, level = 0.95, estimand = NULL, point_size = 2.8, ...)
}
\arguments{
\item{x}{An object of class \code{"mrs"}.}

\item{level}{Confidence level.}

\item{estimand}{Optional subset of estimands to plot.}

\item{point_size}{Point size.}

\item{...}{Unused.}
}
\value{
Invisibly returns a \code{ggplot2} object.
}
\description{
Plots unadjusted vs adjusted estimates with t-based confidence intervals
computed from delete-1 cluster jackknife SEs (df = I - 1). Facets by estimand.
}
\examples{
\donttest{
data(sw_c)
dat <- sw_c[sw_c$cluster \%in\% sort(unique(sw_c$cluster))[1:6], ]

fit <- mrstdlcrt_fit(
  data = dat,
  formula = y ~ trt + factor(period) + x1 + x2 + (1 | cluster),
  cluster_id = "cluster", period = "period", trt = "trt",
  method = "lmer", family = "gaussian"
)

plot(fit)
}
}
