% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R
\docType{class}
\name{MVLasso-class}
\alias{MVLasso-class}
\title{MRMVLasso class}
\description{
An object containing the estimates produced using the multivariable MR-Lasso method as well as various statistics.
}
\section{Slots}{

\describe{
\item{\code{Exposure}}{The names of the exposure variables.}

\item{\code{Outcome}}{The name of the outcome variable.}

\item{\code{Orientate}}{The number of the risk factor that genetic associations are orientated to. The default value is \code{1}, meaning that genetic associations with the first risk factor are set to be positive.}

\item{\code{Estimate}}{The causal estimates from the multivariable MR-Lasso method.}

\item{\code{StdError}}{The standard errors associated with \code{Estimate}.}

\item{\code{CILower}}{The lower bounds of the confidence intervals for \code{Estimate} based on \code{StdError}.}

\item{\code{CIUpper}}{The upper bounds of the confidence intervals for \code{Estimate} based on \code{StdError}.}

\item{\code{Alpha}}{The significance level used in constructing the confidence interval (default is 0.05).}

\item{\code{Pvalue}}{P-values associated with the causal estimates from the multivariable MR-Lasso method.}

\item{\code{SNPs}}{The number of SNPs used in the calculation.}

\item{\code{RegEstimate}}{The estimates from the regularized regression model used in the multivariable MR-Lasso method.}

\item{\code{RegIntercept}}{The intercept estimates from the regularized regression model used in the multivariable MR-Lasso method. An intercept estimate of zero identifies the corresponding genetic variant as a valid instrument. Genetic variants with non-zero intercept estimates will be excluded from the MR-Lasso method, which is obtained as a post-lasso estimator.}

\item{\code{Valid}}{The number of genetic variants that have been identified as valid instruments.}

\item{\code{ValidSNPs}}{The names of genetic variants that have been identified as valid instruments.}

\item{\code{Lambda}}{The value of the tuning parameter used to compute \code{RegEstimate} (default is to calulate \code{Lambda} using the heterogeneity stopping rule).}
}}

