% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SS2MOM.R
\name{SS2DataMOM}
\alias{SS2DataMOM}
\title{Reads data Stock Synthesis file structure into a nested Data object analogous with multiMSE}
\usage{
SS2DataMOM(SSdir, age_M = NULL, comp_partition = 2, silent = FALSE, ...)
}
\arguments{
\item{SSdir}{A folder with Stock Synthesis input and output files in it. Alternatively,}

\item{age_M}{A vector of ages to average across to calculate a single value of natural mortality.
Currently, the Data object supports a single value of M for all ages. By default, \code{NULL} averages over all ages.}

\item{comp_partition}{Integer vector for selecting length/age observations that are retained (2), discarded (1), or both (0). By default, only retained
comps are used. If multiple codes are used, then comp matrix is the sum over all codes.}

\item{silent}{Logical. Suppress messages?}

\item{...}{Arguments to pass to \link[r4ss]{SS_output}}
}
\value{
A nested list of Data objects, with the first index by stock/sex and the second index by fleet.
}
\description{
A function that uses the file location of a fitted SS3 model including input files to population
the various slots of an Data object.
}
\note{
Currently tested on r4ss version 1.38.1-41 and SS 3.30.14.

Catches in \code{Data@Cat} are the predicted sex-specific catch calculated from the SS output.
}
\seealso{
\link{SS2MOM}
}
\author{
Q. Huynh
}
