#' @title County data
#'
#' @description
#' Data for 3142 counties in the United States containing demographic,
#' educational, economic, and technological statistics.
#'
#' @format A data frame with 3142 rows and 17 columns:
#' \describe{
#'   \item{state}{State (character)}
#'   \item{name}{County name (character)}
#'   \item{fips}{County level FIPS code (integer)}
#'   \item{pop}{County population (integer)}
#'   \item{households}{Number of households (integer)}
#'   \item{median_age}{Median age of people in county (numeric)}
#'   \item{age_over_18}{Percent age of people over 18 (numeric)}
#'   \item{age_over_65}{Percent age of people over 65 (numeric)}
#'   \item{hs_grad}{Percent of highschool grads (numeric)}
#'   \item{bachelors}{Percent of people with bachelors degrees (numeric)}
#'   \item{white}{Percent of population that is white (numeric)}
#'   \item{black}{Percent of population that is black (numeric)}
#'   \item{hispanic}{Percent of population that is hispanic (numeric)}
#'   \item{household_has_smartphone}{Percent of households who have a smartphone (numeric)}
#'   \item{mean_household_income}{Average household income (integer)}
#'   \item{median_household_income}{Median household income (integer)}
#'   \item{unemployment_rate}{Unemployment rate (numeric)}
#' }
#'
#' @source Adapted from the county_complete data set
#' in the \href{https://CRAN.R-project.org/package=usdata}{usdata library} with
#' alterations made for educational purposes.
"county_data"
