% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MPCum_optimal_n.R
\name{MPCum_optimal_n}
\alias{MPCum_optimal_n}
\title{Optimal Test Sample Size for Multi-state RDT with Multiple Periods and Criteria for Cumulative Periods}
\usage{
MPCum_optimal_n(cvec, pivec, Rvec, thres_CR)
}
\arguments{
\item{cvec}{Maximum allowable failures for each separate period}

\item{pivec}{Failure probability for each seperate period}

\item{Rvec}{Lower level reliability requirements for each cumulative period from the begining of the test.}

\item{thres_CR}{Threshold (acceptable level) of consumer's risk}
}
\value{
Minimum test sample size
}
\description{
Define the optimal function to find the optimal test plan with minimum test sample size given an acceptable level of consumer's risk.
The maximum allowable failures for each cumulative period need to be satisfied to pass the test (for Multi-state RDT, Multiple Periods, Scenario I)
}
\examples{
\donttest{
pi <- pi_MCSim_dirichlet(M = 5000, seed = 10, par = c(1, 1, 1))
MPCum_optimal_n(cvec = c(1,1), pivec = pi, Rvec = c(0.8, 0.7), thres_CR = 0.05)
}
}
