% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MP_Indicator.R
\name{MP_Indicator}
\alias{MP_Indicator}
\title{Binary Indicator for Multi-state RDT with Multiple Periods}
\usage{
MP_Indicator(pivec, Rvec)
}
\arguments{
\item{pivec}{Failure probability for each separate period.}

\item{Rvec}{Lower level reliability requirements for each cumulative period from the begining of the test.}
}
\value{
0 -- No; 1 -- Yes.
}
\description{
Define the binary indicator function to check whether the failure probability satisfies the lower level reliability requirements for each cumulative period (for Multi-state RDT, Multiple Periods)
}
\examples{
MP_Indicator(pivec = c(0.1, 0.2), Rvec = c(0.8, 0.6))
MP_Indicator(pivec = c(0.1, 0.2, 0.1), Rvec = c(0.8, 0.6, 0.4))
MP_Indicator(pivec = c(0.1, 0.3), Rvec = c(0.8, 0.7))
}
