% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotMV.R
\name{plotMV}
\alias{plotMV}
\title{Plot predictions}
\usage{
plotMV(MUVRclassObject, model = "min", factCols, sampLabels, ylim = NULL)
}
\arguments{
\item{MUVRclassObject}{An MUVR class object}

\item{model}{What type of model to plot ('min', 'mid' or 'max'). Defaults to 'mid'.}

\item{factCols}{An optional vector with colors for the factor levels (in the same order as the levels)}

\item{sampLabels}{Sample labels (optional; implemented for classification)}

\item{ylim}{Optional for imposing y-limits for regression and classification analysis}
}
\value{
A plot of results from multivariate predictions
}
\description{
Plot predicted and actual target variables, with different plots depending on modelling approach.
}
\examples{
\donttest{
data("freelive2")
nRep <- 2
nOuter <- 4
varRatio <-0.6
regrModel <- MUVR2(X = XRVIP2,
                   Y = YR2,
                   nRep = nRep,
                  nOuter = nOuter,
                   varRatio = varRatio,
                   method = "PLS",
                   modReturn = TRUE)
plotMV(regrModel, model="min")
}
}
