% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MVOPR.R
\name{MVOPR2}
\alias{MVOPR2}
\title{Multi-View Orthogonal Projection Regression for two modalities}
\usage{
MVOPR2(
  M1,
  M2,
  Y,
  RRR_Control = list(Sparsity = TRUE, nrank = 10, ic.type = "GIC"),
  family = "gaussian",
  penalty = "lasso"
)
}
\arguments{
\item{M1}{A numeric matrix (n x p) for the first modality.}

\item{M2}{A numeric matrix (n x q) for the second modality. Assumes `M2` is correlated to `M1` via a low-rank matrix.}

\item{Y}{A numeric response vector of length `n`, connected to `M1` and `M2`.}

\item{RRR_Control}{A list to control the fitting for reduced rank regression.
\describe{
    \item{\code{Sparsity}}{Logical. If `TRUE`, performs Sparse Orthogonal Factor Regression (SOFAR); otherwise, a reduced-rank regression model is fitted.}
    \item{\code{nrank}}{Integer. Maximum rank to be searched for the reduced-rank model.}
    \item{\code{ic.type}}{Character. Model selection criterion: `"AIC"`, `"BIC"`, or `"GIC"`.}
  }}

\item{family}{Either "gaussian", "binomial", or "poisson", depending on the response.}

\item{penalty}{The penalty to be applied in the outcome model Y to M1 and M2. Either "MCP" (the default), "SCAD", or "lasso".}
}
\value{
A list containing:
\describe{
  \item{\code{fitY}}{Results for Outcome regression (Y~M1+M2). A fitted object from `cv.ncvreg`, which contains the penalized regression results for `Y`.}
  \item{\code{fitM2}}{Results for reduced-rank regression (M2~M1).The fitted reduced-rank regression model from `rrpack`.}
  \item{\code{CoefY}}{A vector of estimated regression coefficients for `M1` and `M2` on `Y`.}
  \item{\code{coefM2}}{A matrix of estimated regression coefficients for `M1` on `M2`.}
  \item{\code{rank}}{An integer indicates the estimated rank of the reduced-rank regression.}
  \item{\code{P}}{A projection matrix used to extract the orthogonal components of `M1`.}
  \item{\code{M1s}}{Transformed version of `M1` after projection.}
  \item{\code{M2s}}{Transformed version of `M2` after removing the effect of `M1`.}
}
}
\description{
Fit Multi-View Orthogonal Projection Regression for two modalities with Lasso, MCP, SCAD. The function is capable for linear, logistic, and poisson regression.
}
\examples{

## Simulation.1
p = 100; q = 100; n = 200
rank = 3

beta = c(rep(c(rep(1,5),rep(0,95)),2))
M1 = matrix(rnorm(p*n),n,p)

U = matrix(rnorm(rank*p),p,rank)
V = matrix(rnorm(rank*q),rank,q)
B = U \%*\% V
E = matrix(rnorm(q*n),n,q)
M2 = M1 \%*\% B + E
Y = cbind(M1,M2) \%*\% matrix(beta,p+q,1)

Fit = MVOPR2(M1,M2,Y,RRR_Control = list(Sparsity = FALSE))

## Result for variable selection
print(data.frame(Truecoef = beta,estimate = Fit$CoefY[2:(p+q+1)]))

## Plot the pathway and cv error in outcome model
oldpar <- par(mfrow = c(1, 2))
on.exit(par(oldpar))
plot(Fit$fitY$fit)
plot(Fit$fitY)


}
\references{
Dai, Z., Huang, Y. J., & Li, G. (2025). Multi-View Orthogonal Projection Regression with Application in Multi-omics Integration. arXiv preprint arXiv:2503.16807. Available at <https://arxiv.org/abs/2503.16807>
}
