% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{InitializePopulationLHS}
\alias{InitializePopulationLHS}
\title{Initialize population with Latin Hypercube Sampling}
\usage{
InitializePopulationLHS(
  numberOfIndividuals,
  chromosomeLength,
  minVal = 0,
  maxVal = 1,
  samplingMethod = 0
)
}
\arguments{
\item{numberOfIndividuals}{The number of individual in the population (ncol). Integer > 0.}

\item{chromosomeLength}{The number of variables per individual (nrow)}

\item{minVal}{Minimum value of the resulting sample}

\item{maxVal}{Maximum value of the resulting sample}

\item{samplingMethod}{Not used}
}
\value{
A matrix of size chromosomeLength x nIndividual.
}
\description{
Create initial sample using Latin Hypercube Sampling (LHS) method. The variables will be ranged between 0-1
}
\examples{
nVar <- 14
nIndividual <- 100
InitializePopulationLHS(nIndividual,nVar,FALSE)
}
