% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{roll_up_optimal_pairs}
\alias{roll_up_optimal_pairs}
\title{Roll up the suggested test/control optimal pairs for pseudo power analysis (testing fake lift)}
\usage{
roll_up_optimal_pairs(matched_markets=NULL,
                      percent_cutoff=1,
                      synthetic=FALSE)
}
\arguments{
\item{matched_markets}{A matched market object from best_matches.}

\item{percent_cutoff}{The percent of data (by volume) to be included in the future study. Default is 1. 0.5 would be 50 percent.}

\item{synthetic}{If set to TRUE, the control markets are not aggregated so BSTS can determine weights for each market and create a synthetic control.
If set to FALSE then the control markets are aggregated and each market will essentially get the same weight.
If you have many control markets (say, more than 25) it is recommended to choose FALSE. Default is FALSE.}
}
\value{
Returns an object of type \code{market_matching}. The object has the
following elements:
\item{\code{BestMatches}}{A data.frame that contains the best matches for each market in the input dataset}
\item{\code{Data}}{The raw data used to do the matching}
\item{\code{MarketID}}{The name of the market identifier}
\item{\code{MatchingMetric}}{The name of the matching variable}
\item{\code{DateVariable}}{The name of the date variable}
\item{\code{SuggestedTestControlSplits}}{Always NULL}
}
\description{
\code{roll_up_optimal_pairs} Takes the suggested optimal pairs from best_matches() and aggregates the data for pseudo power analysis (test_fake_lift()).
You run this function and then pass the result (a matched markets object) to test_fake_lift.
}
\examples{
\dontrun{
##-----------------------------------------------------------------------
## Generate the suggested test/control pairs
##-----------------------------------------------------------------------
library(MarketMatching)
data(weather, package="MarketMatching")
mm <- best_matches(data=weather, 
                   id="Area",
                   date_variable="Date",
                   matching_variable="Mean_TemperatureF",
                   parallel=FALSE,
                   suggest_market_splits=TRUE,
                   start_match_period="2014-01-01",
                   end_match_period="2014-10-01")
                   
##-----------------------------------------------------------------------
## Roll up the pairs to generate test and control markets
## Synthetic=FALSE means that the control markets will be aggregated 
## -- i.e., equal weighhs in CausalImpact
##-----------------------------------------------------------------------
                   
rollup <- roll_up_optimal_pairs(matched_markets=mm, 
                                percent_cutoff=1, 
                                synthetic=FALSE)
                                
##-----------------------------------------------------------------------
## Pseudo power analysis (fake lift analysis)
##-----------------------------------------------------------------------

results <- test_fake_lift(matched_markets=rollup,
                     test_market="TEST",
                     lift_pattern_type="constant",
                     end_fake_post_period="2015-12-15",
                     prior_level_sd=0.002, 
                     max_fake_lift=0.1)
}
}
