% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formMWRresults.R
\name{formMWRresults}
\alias{formMWRresults}
\title{Format water quality monitoring results}
\usage{
formMWRresults(resdat, tzone = "America/Jamaica")
}
\arguments{
\item{resdat}{input data frame for results}

\item{tzone}{character string for time zone}
}
\value{
A formatted data frame of the water quality monitoring results file
}
\description{
Format water quality monitoring results
}
\details{
This function is used internally within \code{\link{readMWRresults}} to format the input data for downstream analysis.  The formatting includes:

\itemize{
\item Fix date and time inputs: Activity Start Date is converted to YYYY-MM-DD as a date object, Actvity Start Time is convered to HH:MM as a character to fix artifacts from Excel import
\item Minor formatting for Result Unit: For conformance to WQX, e.g., ppt is changed to ppth, s.u. is changed to NA
\item Convert characteristic names: All parameters in \code{Characteristic Name} are converted to \code{Simple Parameter} in \code{\link{paramsMWR}} as needed
}
}
\examples{
library(dplyr)

respth <- system.file('extdata/ExampleResults.xlsx', package = 'MassWateR')

resdat <- suppressWarnings(readxl::read_excel(respth, na = c('NA', 'na', ''), guess_max = Inf)) \%>\% 
  dplyr::mutate_if(function(x) !lubridate::is.POSIXct(x), as.character)
  
formMWRresults(resdat)
}
