% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as.wimids.R
\name{as.wimids}
\alias{as.wimids}
\alias{as.wimids.default}
\title{Create a \code{wimids} object}
\usage{
as.wimids(x, ...)

\method{as.wimids}{default}(x, datasets, ...)
}
\arguments{
\item{x}{A list of \code{weightit} objects, each the output of a call to \code{\link[WeightIt:weightit]{WeightIt::weightit()}} on an imputed dataset.}

\item{...}{Ignored.}

\item{datasets}{The datasets containing the exposure and covariates mentioned in the \code{formula}. This argument must be an object of the \code{mids} or \code{amelia} class, which is typically produced by a previous call to \code{mice()} from the \pkg{mice} package or to \code{amelia()} from the \pkg{Amelia} package (the \pkg{Amelia} package is designed to impute missing data in a single cross-sectional dataset or in a time-series dataset, currently, the \pkg{MatchThem} package only supports the former datasets).}
}
\value{
A \code{\link{wimids}} object.
}
\description{
Creates a \code{wimids} object from a list of \code{weightit} objects and an imputed dataset.
}
\details{
The weighted datasets are stored as though \code{weightthem()} was called with \code{approach = "within"}.
}
\examples{

#Loading the dataset
data(osteoarthritis)

#Multiply imputing the missing values
imputed.datasets <- mice::mice(osteoarthritis, m = 5,
                               printFlag = FALSE)

#Matching the multiply imputed datasets manually
weight.list <- lapply(1:5, function(i) {
  WeightIt::weightit(OSP ~ AGE + SEX + BMI + RAC + SMK,
                     mice::complete(imputed.datasets, i),
                     method = 'glm',
                     estimand = 'ATT')
})

#Creating wimids object
weighted.datasets <- as.wimids(weight.list,
                               imputed.datasets)
}
\seealso{
\code{\link[=weightthem]{weightthem()}}, \code{\link{wimids}}, \code{\link[WeightIt:weightit]{WeightIt::weightit()}}
}
