% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Main.R
\name{MatrixMixt}
\alias{MatrixMixt}
\title{Fitting for Matrix-Variate Mixture Models}
\usage{
MatrixMixt(
  X,
  G = 1:3,
  mod,
  tol = 1e-05,
  maxiter = 10000,
  ncores = 1,
  verbose = TRUE
)
}
\arguments{
\item{X}{A list of dimension \code{N}, where \code{N} is the sample size. Each element of the
list corresponds to an observed p x r matrix.}

\item{G}{A vector containing the numbers of groups to be tried.}

\item{mod}{The matrix-variate distribution to be used for the mixture model. Possible
values are: \code{"MVN"} for the normal distribution, \code{"MVT"} for the
t distribution \code{"MVCN"} for the contaminated normal.}

\item{tol}{Threshold for Aitken's acceleration procedure. Default value is \code{1.0e-05}.}

\item{maxiter}{Maximum number of iterations of the algorithms. Default value is \code{10000}.}

\item{ncores}{A positive integer indicating the number of cores used for running in parallel.
Default value is \code{1}.}

\item{verbose}{Logical indicating whether the running output should be displayed.}
}
\value{
A list with the following elements:
\item{flag}{Convergence flag (TRUE - success, FALSE - failure).}
\item{pig}{Vector of the estimated mixing proportions (length G).}
\item{nu}{Vector of the estimated degree of freedoms (length G). Only for "MVT".}
\item{alpha}{Vector of the estimated inliers proportions (length G). Only for "MVCN".}
\item{eta}{Vector of the estimated inflation parameters (length G). Only for "MVCN".}
\item{M}{Array of the mean matrices (p x r x G).}
\item{Sigma}{Array of the estimated row covariance matrices (p x p x G).}
\item{Psi}{Array of the estimated column covariance matrices (r x r x G).}
\item{class}{Vector of estimated data classification.}
\item{z}{Matrix of estimated posterior probabilities (N x G).}
\item{v}{Matrix of estimated inlier probabilities (N x G). Only for "MVCN".}
\item{lik}{Estimated log-likelihood.}
\item{BIC}{Estimated BIC.}
}
\description{
Fits, by using expectation-maximization algorithms, mixtures of matrix-variate
distributions (normal, t, contaminated normal) to the given data. Can be run
in parallel. The Bayesian information criterion (BIC) is used to select the
number of groups.
}

\examples{
data(SimX)
res <- MatrixMixt(X = SimX, G = 2, mod = "MVCN")
}
