MaxInteraction.plot <-
function(Gamma_matrix, row_counts = NULL) {
  # Assign default row/column names if missing
  if (is.null(rownames(Gamma_matrix))) {
    rownames(Gamma_matrix) <- paste0("Row Cluster ", 1:nrow(Gamma_matrix))
  }
  if (is.null(colnames(Gamma_matrix))) {
    colnames(Gamma_matrix) <- paste0("Column Cluster ", 1:ncol(Gamma_matrix))
  }
  
  # Create long-format data
  df <- data.frame(
    RowCluster = rep(rownames(Gamma_matrix), each = ncol(Gamma_matrix)),
    ColumnCluster = rep(colnames(Gamma_matrix), times = nrow(Gamma_matrix)),
    EstimatedGamma = as.vector(t(Gamma_matrix))
  )
  
  # Compute dynamic y-axis limits
  y_min <- min(df$EstimatedGamma) - 0.1 * diff(range(df$EstimatedGamma))
  y_max <- max(df$EstimatedGamma) + 0.1 * diff(range(df$EstimatedGamma))
  
  # Create plot
  p <- ggplot(df, aes(x = ColumnCluster, y = EstimatedGamma,
                      group = RowCluster, colour = RowCluster)) +
    geom_line(size = 0.8) +
    geom_point(size = 2.0) +
    labs(
      title = "Participant-by-Task Interaction",
      subtitle = "For optimal choice of (P, Q)",
      x = "Column (Items or Tasks) Clusters",
      y = "Estimated Interaction per Bicluster",
      colour = "Row (Participants) Clusters"
    ) +
    theme_bw() +
    coord_cartesian(ylim = c(y_min, y_max)) +
    theme(
      axis.text.x = element_text(face = "bold", size = 12, angle = 90,
                                 vjust = 0.5, hjust = 1),
      axis.text.y = element_text(face = "bold", size = 12),
      plot.title = element_text(hjust = 0.5),
      plot.subtitle = element_text(hjust = 0.5)
    )
  
  # Add caption with counts if provided
  if (!is.null(row_counts)) {
    caption_text <- paste0(
      "Counts: ",
      paste(paste0(rownames(Gamma_matrix), " = ", row_counts, " participants"),
            collapse = "; ")
    )
    p <- p + labs(caption = caption_text)
  }
  
  return(p)
}
