% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/documentationHelpers.R
\name{summariseMeasurementDoc}
\alias{summariseMeasurementDoc}
\title{Helper for consistent documentation of `summariseMeasurement` functions.}
\arguments{
\item{cdm}{A reference to the cdm object.}

\item{codes}{A codelist of measurement/observation codes for which to perform
diagnostics.}

\item{cohort}{A cohort in which to perform the diagnostics of the measurement
codes provided.}

\item{timing}{Three options: 1) "any" if the interest is on measurement
recorded any time, 2) "during", if interested in measurements while the
subject is in the cohort (or in observation if cohort = NULL), and 3)
"cohort_start_date" for measurements occurring at cohort start date (or at
"observation_period_start_date if cohort = NULL).}

\item{byConcept}{TRUE or FALSE. If TRUE code use will be summarised by concept.}

\item{byYear}{TRUE or FALSE. If TRUE code use will be summarised by year.}

\item{bySex}{TRUE or FALSE. If TRUE code use will be summarised by sex.}

\item{ageGroup}{If not NULL, a list of ageGroup vectors of length two.}

\item{dateRange}{Two dates. The first indicating the earliest measurement
date and the second indicating the latest possible measurement date.}

\item{estimates}{A named list indicating, for each measurement diagnostics
check, which estimates to retrieve. The names of the list should correspond
to the diagnostics checks, and each list element should be a character vector
specifying the estimates to compute.

Allowed estimates are those supported by the `summariseResult()` function in
the **PatientProfiles** package. If omitted, all available estimates for
each check will be returned.}

\item{histogram}{Named list where names point to checks for which to get
estimates for a histogram, and elements are numeric vectors indicating the
bind-width. See function examples. Histogram only available for
"measurement_summary" and "measurement_value_as_number".}

\item{checks}{Diagnostics to run. Options are: "measurement_summary",
"measurement_value_as_number", and "measurement_value_as_concept".}
}
\description{
Helper for consistent documentation of `summariseMeasurement` functions.
}
\keyword{internal}
