% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DistHR.R
\name{DistHR}
\alias{DistHR}
\title{Null Distribution of the Estimated HR}
\usage{
DistHR(
  Survival,
  Censor,
  Mdata,
  Prognostic = NULL,
  Quantile = 0.5,
  Reduce = FALSE,
  Select = 15,
  nperm = 100,
  case = 2,
  Validation = c("PLSbased", "PCAbased", "L1based", "MVbased")
)
}
\arguments{
\item{Survival}{A vector of survival time with length equals to number of subjects}

\item{Censor}{A vector of censoring indicator}

\item{Mdata}{A large or small metabolic profile matrix. A matrix with metabolic profiles where the number of rows should be equal to the number of metabolites and number of columns should be equal to number of patients.}

\item{Prognostic}{A dataframe containing possible prognostic(s) factor and/or treatment effect to be used in the model.}

\item{Quantile}{The cut off value for the classifier, default is the median cutoff}

\item{Reduce}{A boolean parameter indicating if the metabolic profile matrix should be reduced, default is TRUE and larger metabolic profile matrix is reduced by supervised pca approach and first pca is extracted from the reduced matrix to be used in the classifier.}

\item{Select}{Number of metabolites (default is 15) to be selected from supervised PCA. This is valid only if the argument Reduce=TRUE}

\item{nperm}{Number of permutations to be used and default 100}

\item{case}{There are seven different ways on how to call this argument:
\enumerate{
\item{Permute survival only.}
\item{Permute survival and rows of data frame of the prognostic factors.}
\item{Permute survival, rows of data frame of the prognostic factors, columns of metabolite matrix independently.}
\item{Permute metabolite matrix only.}
}}

\item{Validation}{There are four different validation schemes where the null distribution can be estimated. That is c("PLSbased","PCAbased","L1based","MVbased").}
}
\value{
A object of class \code{\link[MetabolicSurv]{perm}} is returned with the following values
\item{HRobs}{Estimated HR for low risk group on the original data}
\item{HRperm}{Estimated HR for low risk group on the permuted data}
\item{nperm}{Number of permutations carried out}
\item{Validation}{The validation scheme that was used}
}
\description{
This function generates the null distribution of the HR by permutation approach. Several ways of permutation setting can be implemented. That is, function can be used to generate null distributions for four different validation schemes, PLS based, PCA based, Majority votes based and Lasso based.
}
\details{
This function generates the null distribution of the HR by permutation approach either using a large metabolite matrix or a reduced version by supervised pca approach. Several ways of permutation setting can be implemented. That is, the function can be used to generate null distributions for four different validation schemes which are PLS based, PCA based, Majority votes based and Lasso based. Note this function internally calls function  \code{\link[MetabolicSurv]{SurvPcaClass}}, \code{\link[MetabolicSurv]{SurvPlsClass}}, \code{\link[MetabolicSurv]{Majorityvotes}}, and \code{\link[MetabolicSurv]{Lasoelacox}}.
}
\examples{
\donttest{
## FIRSTLY SIMULATING A METABOLIC SURVIVAL DATA
Data = MSData(nPatients = 100, nMet = 150, Prop = 0.5)

## USING THE FUNCTION
Example <- DistHR(Survival = Data$Survival,Mdata = t(Data$Mdata),
Censor = Data$Censor,Reduce=FALSE,Select=15,Prognostic=Data$Prognostic,
Quantile = 0.5, nperm=10, case=2, Validation=c("L1based"))
}
}
\seealso{
\code{\link[survival]{coxph}}, \code{\link[MetabolicSurv]{EstimateHR}}, \code{\link[MetabolicSurv]{SurvPcaClass}}, \code{\link[MetabolicSurv]{SurvPlsClass}}, \code{\link[MetabolicSurv]{Majorityvotes}}, \code{\link[MetabolicSurv]{Lasoelacox}}, \code{\link[MetabolicSurv]{EstimateHR}}, \code{\link[MetabolicSurv]{Lasoelacox}}
}
\author{
Olajumoke Evangelina Owokotomo, \email{olajumoke.owokotomo@uhasselt.be}

Ziv Shkedy
}
