% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MetricGraph-package.R
\docType{package}
\name{MetricGraph-package}
\alias{MetricGraph}
\alias{MetricGraph-package}
\title{Gaussian processes on metric graphs}
\description{
'MetricGraph' is used for creation and manipulation of metric graphs, such as street or river networks.
It also has several functions thatfacilitates operations and visualizations of data on metric graphs,
and the creation of a large class of random fields and stochastic partial differential equations on
such spaces.
The main models are the Whittle-Matérn fields, which are specified through the
fractional elliptic SPDE
\deqn{(\kappa^2 - \Delta)^{\alpha/2} (\tau u(s)) = W,}
\eqn{\kappa,\tau>0} and \eqn{\alpha>1/2} are parameters and \eqn{W} is Gaussian white noise.
It contains exact implementations of the above model for \eqn{\alpha=1} and \eqn{\alpha=2},
and contains approximate implementations, via the finite element method, for any \eqn{\alpha > 0.5}.
It also implements models based on graph Laplacians and isotropic covariance functions.
Several utility functions for specifying graphs, computing likelihoods, performing
prediction, simulating processes, and visualizing results on metric graphs are provided.
In particular, linear mixed effects models including random field components can be fitted to
data based on computationally efficient sparse matrix representations. Interfaces to the R
packages 'INLA' and 'inlabru' are also provided, which facilitate working with Bayesian statistical
models on metric graphs.
}
\details{
At the heart of the package is the \code{R6} class \verb{[metric_graph()]}. This is used for specifying
metric graphs, and contains various utility functions which are needed for specifying Gaussian
processes on such spaces.

Linear mixed effects models are provided (see
\verb{[graph_lme]}) and perform
predictions (see \verb{[predict.graph_lme]}). The package also has interfaces for
'INLA' (see \verb{[graph_spde]}), and it this interface also works with 'inlabru'.

For a more detailed introduction to the package, see the 'MetricGraph' Vignettes.
}
\seealso{
Useful links:
\itemize{
  \item \url{https://davidbolin.github.io/MetricGraph/}
  \item Report bugs at \url{https://github.com/davidbolin/MetricGraph/issues}
}

}
\author{
\strong{Maintainer}: David Bolin \email{davidbolin@gmail.com}

Authors:
\itemize{
  \item Alexandre Simas \email{alexandre.impa@gmail.com}
  \item Jonas Wallin \email{jonas.wallin81@gmail.com}
}

}
