% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/aSPU.R
\name{MiSPU}
\alias{MiSPU}
\title{microbiome based sum of powered score (MiSPU)}
\usage{
MiSPU(y, X, tree, cov = NULL,model = c("gaussian", "binomial"),
 pow = c(2:8, Inf), n.perm = 1000)
}
\arguments{
\item{y}{Outcome of interest. It can be a disease indicator; =0 for controls, =1 for cases.
Or it can be a quantitative trait. A vector with length n (number of observations).}
\item{X}{OTU count table, row - n sample, column - q OTU}
\item{tree}{Rooted phylogenetic tree of R class \dQuote{phylo}}
\item{cov}{Covariates. A matrix with dimension n by p (n :number of observation, p : number of covariates).}
\item{model}{Use "gaussian" for a quantitative trait, and use "binomial" for a binary trait.}
\item{pow}{The gamma which controls the weight. Larger pow puts more weight on the variables that have larger absolute score.}
\item{n.perm}{number of permutations or bootstraps.}
}
\value{
A list object, including the results for MiSPU_u, MiSPU_w and aMiSPU.
}
\description{
We propose a class of microbiome based sum of powered score (MiSPU) tests based on a newly defined generalized taxon proportion that combines observed microbial composition information with phylogenetic tree information. Different from the existing methods, a MiSPU test is based on a weighted score of the generalized taxon proportion in a general framework of regression, upweighting more likely to be associated microbial lineages. Our simulations demonstrated that one or more MiSPU tests were more powerful than MiRKAT while correctly controlling type I error rates. An adaptive MiSPU (aMiSPU) test is proposed to combine multiple MiSPU tests with various weights, approximating the most powerful MiSPU for a given scenario, consequently being highly adaptive and high powered across various scenarios.
}
\examples{
data(throat.otu.tab)
data(throat.tree)
data(throat.meta)

Y.tmp =throat.meta[,3]
Y = rep(0,dim(throat.meta)[1])
Y[Y.tmp=="Smoker"] = 1

cov.tmp = throat.meta[,c(10,12)]
cov = matrix(1,dim(throat.meta)[1],2)
cov[cov.tmp[,1]== "None",1] = 0
cov[cov.tmp[,2]== "Male",2] = 0

start.time = proc.time()
X = as.matrix(throat.otu.tab)

out = MiSPU(Y,X, throat.tree,cov,model =  "binomial", pow = c(2:8, Inf), n.perm = 1000)
out
}
\author{
Chong Wu
}
\references{
Pan, W., et al.(2014) A powerful and adaptive association test for rare variants, Genetics, 197(4), 1081-95

Chong, W., Pan, W. (2015) An Adaptive Association Test for Microbiome Data, submitted. 
}


