% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/acide.R
\name{Acid.SpecificPair}
\alias{Acid.SpecificPair}
\title{Acid - specific pair (\code{alpha}, \code{MIC})}
\usage{
Acid.SpecificPair(pairs, concentration = 1)
}
\arguments{
\item{pairs}{list of pairs (\code{alpha}, \code{MIC}).}

\item{concentration}{acid concentration (in g/L).}
}
\value{
the acid modeled with the following accessible attributes:
\item{pairs}{list of pairs (\code{alpha}, \code{MIC}).}
\item{concentration}{the acid concentration (in g/L).}
\item{getCoefMin}{function returning the minimum coefficient to apply to a MicrobialGrowth-object (see details section).}
\item{getCoefMid}{function returning the "middle" coefficient to apply to a MicrobialGrowth-object (see details section).}
\item{getCoefMax}{function returning the maximum coefficient to apply to a MicrobialGrowth-object (see details section).}
}
\description{
Modeling of an acid with \code{alpha} its sensitivity and \code{MIC} its minimum inhibition concentration.
The default \code{concentration} is 1g/L.
}
\details{
The \code{pairs} argument can be given as one to three pairs.

A single pair means that \code{getCoefMin}, \code{getCoefMid} and \code{getCoefMax} will return the same coefficient.

Two pairs means that one of them will be used for \code{getCoefMin} and the other for \code{getCoefMax}.
The \code{getCoefMid} function will use an average value of the two pairs.

Three pairs acts like two pairs except that the \code{getCoefMid} function will use this third pair (middle value) to calculate the coefficient.
Note that the pair (\code{alpha}, \code{MIC}) used by \code{getCoefMid} neither minimizes nor maximizes the coefficient (in other words, it is the pair which is neither used in \code{getCoefMin} nor in \code{getCoefMax}).

Please note that if you do not want to use specific pairs but ranges of values for \code{alpha} and/or \code{MIC}, use the parent function \link{Acid}.
}
\examples{
# Classic instantiation
print(Acid.SpecificPair(list(c(1.245, 5.47))))
## acid {{alpha=1.245, MIC=5.47g/L}, concentration=1g/L}

# Classic instantiation by specifying a concentration
print(Acid.SpecificPair(list(c(1.245, 5.47)), 3))
## acid {{alpha=1.245, MIC=5.47g/L}, concentration=3g/L}

# Instantiation with multiple couples (`alpha`, `MIC`) (see details section)
aceticAcid <- Acid.SpecificPair(list(c(0.98,5.68),c(1.51,5.26)))
print(aceticAcid)
## acid {{alpha=0.98, MIC=5.68g/L},
##       {alpha=1.51, MIC=5.26g/L}, concentration=1g/L}

# Generic operators (`+`, `*`, etc.) can change the `concentration` of the acid.
print(aceticAcid / 2)
## acid {{alpha=0.98, MIC=5.68g/L},
##       {alpha=1.51, MIC=5.26g/L}, concentration=0.5g/L}
print(aceticAcid + 2)
## acid {{alpha=0.98, MIC=5.68g/L},
##       {alpha=1.51, MIC=5.26g/L}, concentration=3g/L}

# Without having to pre-define specific concentrations, and with the default `concentration` (1g/L),
# you can dynamically change the acid concentration as follows:
for (concentration in c(0.5, 1, 5, 10)) {
  print(concentration * aceticAcid)
}
## acid {{alpha=0.98, MIC=5.68g/L},
##       {alpha=1.51, MIC=5.26g/L}, concentration=0.5g/L}
## acid {{alpha=0.98, MIC=5.68g/L},
##       {alpha=1.51, MIC=5.26g/L}, concentration=1g/L}
## acid {{alpha=0.98, MIC=5.68g/L},
##       {alpha=1.51, MIC=5.26g/L}, concentration=5g/L}
## acid {{alpha=0.98, MIC=5.68g/L},
##       {alpha=1.51, MIC=5.26g/L}, concentration=10g/L}

try({
  # Acid can be applied to a MicrobilogicalGrowth-object with the `+` addition operator.
  # Note that the acid should be on the right side, otherwise an error is raised.
  MyMicrobialGrowthObject + aceticAcid
  ## returns the MicrobialGrowth-object affected by the acid (several acids can be applied)
})
}
\seealso{
\link{Acid}
}
