% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/baranyi.R
\name{is.baranyi}
\alias{is.baranyi}
\title{Baranyi class}
\usage{
is.baranyi(x)
}
\arguments{
\item{x}{variable or list.}
}
\value{
\code{TRUE} if the object or all objects are of class \code{baranyi}.
}
\description{
Test if a variable or variable list is/are baranyi-object(s).
}
\examples{
# TRUE return
r1 <- MicrobialGrowth(example_data$time, example_data$y1, model="baranyi")
r2 <- MicrobialGrowth.create(N0 = 0.14, Nmax = 1.43, mu = 0.07, lambda = 45,
                                   xlim = c(0, 100), model="baranyi")
is.baranyi(r1)
is.baranyi(r2)
is.baranyi(c(r1, r2))
is.baranyi(list(r1,r2))

# FALSE return
is.baranyi(1)
is.baranyi(list())
is.baranyi(c(r1, r2, 1))
is.baranyi(list(r1, r2, 1))
}
