% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_functions.R
\name{iNEXT_pq}
\alias{iNEXT_pq}
\title{iNterpolation and EXTrapolation of Hill numbers (with iNEXT)}
\usage{
iNEXT_pq(physeq, merge_sample_by = NULL, ...)
}
\arguments{
\item{physeq}{(required) a \code{\link[phyloseq]{phyloseq-class}} object obtained
using the \code{phyloseq} package.}

\item{merge_sample_by}{(default: NULL) if not \code{NULL} samples of
physeq are merged using the vector set by \code{merge_sample_by}. This
merging used the \code{\link[=merge_samples2]{merge_samples2()}}. In the case of
\code{\link[=biplot_pq]{biplot_pq()}} this must be a factor with two levels only.}

\item{...}{Other arguments for the \code{\link[iNEXT:iNEXT]{iNEXT::iNEXT()}} function}
}
\value{
see \code{\link[iNEXT:iNEXT]{iNEXT::iNEXT()}} documentation
}
\description{
\if{html}{\out{
<a href="https://adrientaudiere.github.io/MiscMetabar/articles/Rules.html#lifecycle">
<img src="https://img.shields.io/badge/lifecycle-experimental-orange" alt="lifecycle-experimental"></a>
}}


Note that this function is quite time-consuming due to high dimensionality in metabarcoding community matrix.
}
\examples{
\donttest{
if (requireNamespace("iNEXT")) {
  data("GlobalPatterns", package = "phyloseq")
  GPsubset <- subset_taxa(
    GlobalPatterns,
    GlobalPatterns@tax_table[, 1] == "Bacteria"
  )
  GPsubset <- subset_taxa(
    GPsubset,
    rowSums(GPsubset@otu_table) > 20000
  )
  GPsubset <- subset_taxa(
    GPsubset,
    rowSums(is.na(GPsubset@tax_table)) == 0
  )
  GPsubset@sam_data$human <- GPsubset@sam_data$SampleType \%in\%
    c("Skin", "Feces", "Tong")
  res_iNEXT <- iNEXT_pq(
    GPsubset,
    merge_sample_by = "human",
    q = 1,
    datatype = "abundance",
    nboot = 2
  )
  iNEXT::ggiNEXT(res_iNEXT)
  iNEXT::ggiNEXT(res_iNEXT, type = 2)
  iNEXT::ggiNEXT(res_iNEXT, type = 3)
}
}
}
\author{
Adrien Taudière
This function is mainly a wrapper of the work of others.
Please make a reference to \code{iNEXT::iNEXT()} if you
use this function.
}
