% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MISSINGLSD.R
\name{Missing.LSD}
\alias{Missing.LSD}
\title{Missing Plot in Latin Square Design(LSD)}
\usage{
Missing.LSD(data, r, c, t)
}
\arguments{
\item{data}{a dataframe which contains values of LSD ,Index No.of row ,Index No.of column,Treatments/Index No.of Treatments in the 1st,2nd,3rd and 4th column respectively. In this dataframe, we will replace the missing value with 0 .}

\item{r}{the index no. of row containing the missing value.}

\item{c}{the index no. of column  containing the missing value.}

\item{t}{the index no. of Treatment containing the missing value.}
}
\value{
x.hat : the least sqaure estimate of the missing observation.

SSE.x.hat : Sum of Squares of Error of x.hat.

x.double.hat : the least square estimate of the missing observation under the null hypothesis , H0.

SSE.x.double.hat : Sum of Squares of Error of x.double.hat.

F.stat : Observed value of the Test Statistic.

F.crit.value : Critical value of the Test Statistic.
}
\description{
This function analyses LSD when there is one missing observation.
}
\details{
In LSD setup , if there is one missing observation we can use this function to estimate the missing observation along with Sum of Squares for testing the differential effect of the treatments. Here we estimate the missing observation twice by minimizing the SSE of the design.
}
\examples{
 d=OrchardSprays
d[8,1]=0
 Missing.LSD(d,8,1,1)
}
\author{
Arnab Roy , Debarghya Baul.
}
