% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/membershipStab.R
\name{membershipStab}
\alias{membershipStab}
\title{Node stability from bootstrap community assignments}
\usage{
membershipStab(fit, IS.plot = FALSE)
}
\arguments{
\item{fit}{An object returned by \code{mixMN()} (class \code{mixMN_fit}),
containing \code{$communities$original_membership} and
\code{$communities$boot_memberships}. Bootstrap memberships must be
available, i.e. \code{reps > 0} and \code{"community" \%in\% boot_what}.}

\item{IS.plot}{Logical; if \code{TRUE}, prints a stability plot via the
internal helper \code{membershipStab_plot()}.}
}
\value{
An object of class \code{c("membershipStab")}, with components:
\describe{
  \item{\code{membership}}{List with:
    \describe{
      \item{\code{empirical}}{Named integer vector of empirical community labels}
      \item{\code{bootstrap}}{Matrix of homogenized bootstrap labels
        (\code{reps × p})}
    }
  }
  \item{\code{membership.stability}}{List with:
    \describe{
      \item{\code{empirical.dimensions}}{Named numeric vector of node-level stability
        (proportion assigned to empirical community)}
      \item{\code{all.dimensions}}{Matrix (\code{p × K}) with proportions of
        assignment to each community}
    }
  }
  \item{\code{community_palette}}{Named vector of colors for communities,
    if available}
}
}
\description{
Computes per-node stability given the empirical community structure and the
homogenized bootstrap memberships contained in a \code{mixMN_fit} object.
This function is used internally by \code{mixMN()} and \code{multimixMN()}.
Stability is expressed as the proportion of bootstrap replications that
assign each node to its empirical (original) community.
}
\details{
Bootstrap community labels are first aligned to the empirical solution using
\code{EGAnet::community.homogenize()}. Stability is then computed node-wise as
the proportion of bootstrap runs in which the node's community matches its
empirical assignment.
}
\references{
Christensen, A. P., & Golino, H. (2021).
Estimating the Stability of Psychological Dimensions via Bootstrap Exploratory Graph Analysis:
A Monte Carlo Simulation and Tutorial. \emph{Psych}, 3(3), 479–500.
\doi{10.3390/psych3030032}
}
