% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/em_methode_with_gibbs.R
\name{em_estimate_stable_weighted_ols_with_gibbs}
\alias{em_estimate_stable_weighted_ols_with_gibbs}
\title{EM algorithm for alpha-stable mixture using weighted OLS and Gibbs M-step}
\usage{
em_estimate_stable_weighted_ols_with_gibbs(data, max_iter = 100, tol = 1e-04)
}
\arguments{
\item{data}{Numeric vector of observations.}

\item{max_iter}{Maximum number of EM iterations.}

\item{tol}{Convergence tolerance on log-likelihood.}
}
\value{
A list with estimated component parameters (\code{alpha}, \code{beta}, \code{gamma}, \code{delta}) and mixture weight (\code{w}).
}
\description{
Performs EM estimation of a two-component alpha-stable mixture using weighted
least squares regression on the ECF, with the M-step replaced by Gibbs sampling.
}
