% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get.pedigree.R
\name{get.pedigree2}
\alias{get.pedigree2}
\title{Derive pedigree including grandparents}
\usage{
get.pedigree2(
  population,
  database = NULL,
  gen = NULL,
  cohorts = NULL,
  shares = FALSE,
  founder.zero = TRUE,
  raw = FALSE,
  include.error = FALSE
)
}
\arguments{
\item{population}{Population list}

\item{database}{Groups of individuals to consider for the export}

\item{gen}{Quick-insert for database (vector of all generations to export)}

\item{cohorts}{Quick-insert for database (vector of names of cohorts to export)}

\item{shares}{Determine actual inherited shares of grandparents}

\item{founder.zero}{Parents of founders are displayed as "0" (default: TRUE)}

\item{raw}{Set to TRUE to not convert numbers into Sex etc.}

\item{include.error}{Set to TRUE to include errors simulated in the pedigree}
}
\value{
Pedigree-file (grandparents) for in gen/database/cohorts selected individuals
}
\description{
Derive pedigree for selected individuals including grandparents
}
\examples{
data(ex_pop)
get.pedigree2(ex_pop, gen=3)
}
