% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get.qtl.R
\name{get.qtl.variance}
\alias{get.qtl.variance}
\title{QTL effect variance extraction}
\usage{
get.qtl.variance(
  population,
  gen = NULL,
  database = NULL,
  cohorts = NULL,
  id = NULL
)
}
\arguments{
\item{population}{Population list}

\item{gen}{Quick-insert for database (vector of all generations to consider)}

\item{database}{Groups of individuals to consider}

\item{cohorts}{Quick-insert for database (vector of names of cohorts to consider)}

\item{id}{Individual IDs to search/collect in the database}
}
\value{
matrix with SNP / Chr / estimated effect variance
}
\description{
Function to extract QTL effect variance for single SNP QTLs in a given gen/database/cohort
}
\examples{
data(ex_pop)
effects <- get.qtl.variance(ex_pop)
}
