% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coo-utilities.R
\name{coo_sample}
\alias{coo_sample}
\title{Sample coordinates (among points)}
\usage{
coo_sample(coo, n)
}
\arguments{
\item{coo}{either a \code{matrix} of (x; y) coordinates or an \link{Out} or an \link{Opn} object.}

\item{n}{\code{integer}, the number fo points to sample.}
}
\value{
a \code{matrix} of (x; y) coordinates, or an \link{Out} or an \link{Opn} object.
}
\description{
Sample n coordinates among existing points.
}
\details{
For the \link{Out} an \link{Opn}
methods (pointless for \link{Ldk}), in an \code{$ldk} component is defined,
it is changed accordingly by multiplying the ids by n over the number of coordinates.
}
\examples{
b <- bot[1]
stack(bot)
stack(coo_sample(bot, 24))
coo_plot(b)
coo_plot(coo_sample(b, 24))
}
\seealso{
Other sampling functions: 
\code{\link{coo_extract}()},
\code{\link{coo_interpolate}()},
\code{\link{coo_sample_prop}()},
\code{\link{coo_samplerr}()}

Other coo_ utilities: 
\code{\link{coo_align}()},
\code{\link{coo_aligncalliper}()},
\code{\link{coo_alignminradius}()},
\code{\link{coo_alignxax}()},
\code{\link{coo_baseline}()},
\code{\link{coo_bookstein}()},
\code{\link{coo_boundingbox}()},
\code{\link{coo_calliper}()},
\code{\link{coo_centdist}()},
\code{\link{coo_center}()},
\code{\link{coo_centpos}()},
\code{\link{coo_close}()},
\code{\link{coo_down}()},
\code{\link{coo_dxy}()},
\code{\link{coo_extract}()},
\code{\link{coo_flipx}()},
\code{\link{coo_force2close}()},
\code{\link{coo_interpolate}()},
\code{\link{coo_is_closed}()},
\code{\link{coo_jitter}()},
\code{\link{coo_left}()},
\code{\link{coo_likely_clockwise}()},
\code{\link{coo_nb}()},
\code{\link{coo_perim}()},
\code{\link{coo_range}()},
\code{\link{coo_rev}()},
\code{\link{coo_right}()},
\code{\link{coo_rotate}()},
\code{\link{coo_rotatecenter}()},
\code{\link{coo_sample_prop}()},
\code{\link{coo_samplerr}()},
\code{\link{coo_scale}()},
\code{\link{coo_shearx}()},
\code{\link{coo_slice}()},
\code{\link{coo_slide}()},
\code{\link{coo_slidedirection}()},
\code{\link{coo_slidegap}()},
\code{\link{coo_smooth}()},
\code{\link{coo_smoothcurve}()},
\code{\link{coo_template}()},
\code{\link{coo_trans}()},
\code{\link{coo_trim}()},
\code{\link{coo_trimbottom}()},
\code{\link{coo_trimtop}()},
\code{\link{coo_untiltx}()},
\code{\link{coo_up}()},
\code{\link{is_equallyspacedradii}()}
}
\concept{coo_ utilities}
\concept{sampling functions}
