% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/morpho.R
\name{morpho}
\alias{morpho}
\alias{as.morpho}
\alias{is.morpho}
\title{Morpho object}
\usage{
morpho(
  sequences = NULL,
  trees = NULL,
  model = NULL,
  transition_history = NULL,
  root.states = NULL,
  fossil = NULL
)

as.morpho(
  sequences,
  trees,
  model = NULL,
  transition_history = NULL,
  root.states = NULL,
  fossil = NULL
)

is.morpho(sequences)
}
\arguments{
\item{sequences}{A list containing all of the sequences simulated. This can contain sequences for taxa
at the tips or the tree, along the nodes, and if present, for sampled ancestors (SA)}

\item{trees}{A list containing the trees and branch lengths used for the simulation. EvolTree contains a
phylogenetic tree with branch lengths representing evolutionary distance. TimeTree (if present)
contains the same tree with branch lengths in unit of time. BrRates can either be a single value, when
simulating under a strict clock, or a vector of values representing the rate/branch}

\item{model}{A list containing all model attributes. Model specifies the components specified to simulate under.
RateVar contains the relative values drawn from the specified distribution. RateVarTrait species the rate used
to simulate each trait}

\item{transition_history}{The constant character transitions along the branches}

\item{root.states}{A vector supplying the root state for each character}

\item{fossil}{Fossil object used to simulate data}
}
\value{
An object of class \code{"morpho"} containing the simulated morphological
data and associated information. The object includes the simulated
sequences, phylogenetic trees and branch rates used for the simulation,
model parameters, root states, fossil information (if provided), and the
character transition history.
}
\description{
Create a morpho object.
}
