% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write.r
\name{write.recon.tsv}
\alias{write.recon.tsv}
\title{Write the taxa ages of reconstructed tree}
\usage{
write.recon.tsv(data, file, uncertainty = 0)
}
\arguments{
\item{data}{Morpho object}

\item{file}{File name}

\item{uncertainty}{Numeric. Adds uncertainty to fossil ages in the morpho object.
The ages in the object are point estimates by default; setting `uncertainty`
will create an age range of ± this value (in millions of years).}
}
\value{
No return value, called for its side effect of writing data to a file.
}
\description{
Writes the ages of the specimen in the reconstructed tree to a file. The tsv format used
here is directly compatible with RevBayes
}
\examples{
data(morpho_data)
tmp <- tempfile(fileext = ".tsv")
write.recon.tsv(data = morpho_data, file = tmp)

}
