#' Measurements from the vertebral column of an alligator
#'
#' Linear and angular measurements from Alligator mississipiensis MCZ 81457
#' @docType data
#' @format A matrix with 22 vertebrae and 19 measurements. Column 1, vertebra, is the positional
#' information.
#'
#' @keywords datasets
"alligator"

#' Measurements from the vertebral column of a mouse
#'
#' Linear and angular measurements from Mus musculus MCZ 59560
#' @docType data
#' @format A matrix with 23 vertebrae and 19 measurements. Column 1, vertebra, is the positional
#' information.
#'
#' @keywords datasets
"musm"

#' Measurements from the vertebral column of a dolphin
#'
#' Linear and angular measurements from Platanista gangetica SMNS 45653
#' @docType data
#' @format A matrix with 40 vertebrae and 16 measurements. Column 1, vertebra, is the positional
#' information.
#'
#' @keywords datasets
"dolphin"

#' Measurements from the vertebral column of three porpoises
#'
#' Linear and angular measurements from Phocoena phocoena NRM 815072 (`porpoise1`), NRM 835011 (`porpoise2`), and NRM 855083 (`porpoise3`).
#' @docType data
#' @usage data("porpoise")
#' @format Each is a data frame with 58, 56, and 59 vertebrae (respectively) and 16 measurements. Column 1, Vertebra, contains the positional information.
#'
#' @keywords datasets
#' @references Gillet, A., Frederich, B., Pierce, S. E., & Parmentier, E. (2022). Iterative habitat transitions are associated with morphological convergence of the backbone in delphinoids. Journal of Mammalian Evolution, 29(4), 931-946.
#' @name porpoise
"porpoise1"

#' @rdname porpoise
#' @usage NULL
#' @format NULL
"porpoise2"

#' @rdname porpoise
#' @usage NULL
#' @format NULL
"porpoise3"